<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

class CreateReportsTable extends Migration
{
    public function up()
    {
        Schema::create('Reports', function (Blueprint $table) {
            $table->id('Report_id');
            $table->unsignedBigInteger('User_id')->nullable()->index();
            $table->string('Report_type')->default('payment_summary'); // e.g., payment_summary, user_activity
            $table->decimal('Total_amount', 10, 2)->default(0.00);
            $table->integer('Transaction_count')->default(0);
            $table->enum('Payment_status', ['pending', 'completed', 'failed'])->nullable();
            $table->dateTime('Report_date')->default(DB::raw('CURRENT_TIMESTAMP'));
            $table->timestamps();

            $table->foreign('User_id')->references('User_id')->on('Users')->onDelete('set null');
        });
    }

    public function down()
    {
        Schema::dropIfExists('Reports');
    }
}
